/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class EventContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double startValue;
    private final Map<Long, Double> changes;
    private final Map<Long, String> descriptions;
    private double absSum;
    private double plusSum;
    private double minusSum;

    public EventContainer(double startValue) {
        this.startValue = startValue;
        this.changes = new HashMap<Long, Double>();
        this.descriptions = new HashMap<Long, String>();
        this.absSum = 0.0;
        this.plusSum = 0.0;
        this.minusSum = 0.0;
    }

    public void clear() {
        this.changes.clear();
        this.descriptions.clear();
        this.absSum = 0.0;
        this.plusSum = 0.0;
        this.minusSum = 0.0;
    }

    public void put(long time, double change) {
        this.put(time, change, null);
    }

    public void put(long time, double change, String description) {
        if (change == 0.0) {
            return;
        }
        if (this.changes.containsKey(time)) {
            this.changes.put(time, this.changes.get(time) + change);
        } else {
            this.changes.put(time, change);
        }
        if (description != null && !description.isEmpty()) {
            if (this.descriptions.containsKey(time)) {
                this.descriptions.put(time, this.descriptions.get(time) + "\n" + description);
            } else {
                this.descriptions.put(time, description);
            }
        }
        this.absSum += Math.abs(change);
        if (change > 0.0) {
            this.plusSum += change;
        }
        if (change < 0.0) {
            this.minusSum -= change;
        }
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public long getMinTime() {
        if (this.changes.isEmpty()) {
            return 0L;
        }
        return this.getSortedEventTimes().get(0);
    }

    public long getMaxTime() {
        if (this.changes.isEmpty()) {
            return 0L;
        }
        return this.getSortedEventTimes().get(this.changes.size() - 1);
    }

    public double getAbsSum() {
        return this.absSum;
    }

    public double getPlusSum() {
        return this.plusSum;
    }

    public double getMinusSum() {
        return this.minusSum;
    }

    public double getChangeAt(long time) {
        if (!this.changes.containsKey(time)) {
            throw new NoSuchElementException();
        }
        return this.changes.get(time);
    }

    public String getDescriptionAt(long time) {
        if (!this.changes.containsKey(time)) {
            throw new NoSuchElementException();
        }
        if (!this.descriptions.containsKey(time)) {
            return null;
        }
        return this.descriptions.get(time);
    }

    public String getDescriptionAt(long time, long tolerance) {
        StringBuilder buffer = new StringBuilder();
        for (long t : this.changes.keySet()) {
            if (t < time - tolerance || t > time + tolerance) continue;
            buffer.append("\n");
            buffer.append(this.getDescriptionAt(t));
        }
        return buffer.toString().trim();
    }

    public List<Long> getSortedEventTimes() {
        ArrayList<Long> list = new ArrayList<Long>(this.changes.keySet());
        Collections.sort(list);
        return Collections.unmodifiableList(list);
    }

    public List<Long> getSortedEventTimes(long from, long to) {
        if (from < 0L || to < 0L || from > to) {
            throw new IllegalArgumentException("Invalid time bounds.");
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (long time : this.changes.keySet()) {
            if (time < from || time > to) continue;
            list.add(time);
        }
        Collections.sort(list);
        return Collections.unmodifiableList(list);
    }

    public double getValueAt(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Invalid time.");
        }
        double value = this.startValue;
        Set<Map.Entry<Long, Double>> entries = this.changes.entrySet();
        for (Map.Entry<Long, Double> entry : entries) {
            if (entry.getKey() > time) continue;
            value += entry.getValue().doubleValue();
        }
        return value;
    }

    public double getChangesRange(long from, long to, double min2) {
        if (from < 0L || to < 0L || from > to) {
            throw new IllegalArgumentException(String.format("Invalid time bounds [from %d to %d (min %f)].", from, to, min2));
        }
        double range = this.getValueAt(from);
        double value = this.startValue;
        for (long t : this.getSortedEventTimes()) {
            value += this.changes.get(t).doubleValue();
            if (t < from || t > to || !(Math.abs(value) > range)) continue;
            range = Math.abs(value);
        }
        return Math.max(min2, range);
    }

    public boolean isNegative(long from, long to) {
        if (from < 0L || to < 0L || from > to) {
            throw new IllegalArgumentException("Invalid time bounds.");
        }
        double value = this.startValue;
        for (long t : this.getSortedEventTimes()) {
            value += this.changes.get(t).doubleValue();
            if (t < from || t > to || !(value < 0.0)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("EventContainer (count %d, |%.3f|, [+] %.3f, [-] %.3f, time %d - %d)", this.changes.size(), this.getAbsSum(), this.getPlusSum(), this.getMinusSum(), this.getMinTime(), this.getMaxTime());
    }
}

